/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.impl;

import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.Node;
import net.xfra.qizxopen.dm.SAXEventReceiver;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class SAXSourceWrapper
implements XMLReader {
    static final String FEATURE_NS = "http://xml.org/sax/features/namespaces";
    static final String FEATURE_NSPREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    static final String PROPERTY_LEXICAL = "http://xml.org/sax/properties/lexical-handler";
    private SAXEventReceiver saxout = new SAXEventReceiver();
    private Node root;

    public SAXSourceWrapper(Node node) {
        this.root = node;
    }

    public ContentHandler getContentHandler() {
        return this.saxout.getContentHandler();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.saxout.setContentHandler(contentHandler);
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return this.saxout.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxout.setErrorHandler(errorHandler);
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(FEATURE_NS)) {
            return true;
        }
        if (string.equals(FEATURE_NSPREFIXES)) {
            return this.saxout.nsPrefixes;
        }
        throw new SAXNotSupportedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(FEATURE_NS)) {
            if (!bl) {
                throw new SAXNotSupportedException(string);
            }
        } else if (string.equals(FEATURE_NSPREFIXES)) {
            this.saxout.nsPrefixes = bl;
        } else {
            throw new SAXNotSupportedException(string);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(PROPERTY_LEXICAL)) {
            return this.saxout.getLexicalHandler();
        }
        throw new SAXNotSupportedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(PROPERTY_LEXICAL)) {
            this.saxout.setLexicalHandler((LexicalHandler)object);
        }
        throw new SAXNotSupportedException(string);
    }

    public void parse(InputSource inputSource) throws SAXException {
        this.exec();
    }

    public void parse(String string) throws SAXException {
        this.exec();
    }

    private void exec() throws SAXException {
        try {
            this.saxout.nsPrefixes = true;
            this.saxout.traverse(this.root, false);
        }
        catch (DataModelException dataModelException) {
            throw new SAXException("traversal error", dataModelException);
        }
    }
}

