/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.CoreDataModel;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.NodeConstructor;

public class AtomConstructor
extends NodeConstructor {
    public int kind;

    public AtomConstructor(int n, Expression expression) {
        Expression[] expressionArray;
        this.kind = n;
        if (expression == null) {
            expressionArray = new Expression[]{};
        } else {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = expression;
        }
        this.contents = expressionArray;
        this.type = Type.TEXT;
        if (n == 6) {
            this.type = Type.COMMENT;
        }
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "AtomConstructor");
        exprDump.display("kind", "" + this.kind);
        exprDump.display("contents", this.contents);
    }

    public Node evalAsNode(Focus focus, EvalContext evalContext) throws XQueryException {
        CoreDataModel.TextNode textNode;
        if (this.kind == 7) {
            textNode = CoreDataModel.newTextNode();
        } else if (this.kind == 6) {
            textNode = CoreDataModel.newCommentNode();
        } else {
            throw new RuntimeException("bad AtomConstructor");
        }
        boolean bl = true;
        int n = 0;
        while (n < this.contents.length) {
            Value value = this.contents[n].eval(focus, evalContext);
            while (value.next()) {
                if (!bl) {
                    textNode.addText(" ");
                }
                bl = false;
                textNode.addText(value.asString());
            }
            ++n;
        }
        return textNode;
    }

    public void evalAsEvents(XMLEventReceiver xMLEventReceiver, Focus focus, EvalContext evalContext) throws XQueryException, DataModelException {
        Object object;
        evalContext.at(this);
        if (this.kind == 7) {
            int n = 0;
            while (n < this.contents.length) {
                Value value = this.contents[n].eval(focus, evalContext);
                while (value.next()) {
                    xMLEventReceiver.atom(value.asString());
                }
                ++n;
            }
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.contents.length) {
            object = this.contents[n].eval(focus, evalContext);
            while (object.next()) {
                stringBuffer.append(object.asString());
            }
            ++n;
        }
        object = stringBuffer.toString();
        if (this.kind != 6) {
            throw new RuntimeException("bad AtomConstructor");
        }
        xMLEventReceiver.comment((String)object);
    }
}

