/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.GenericValue;
import net.xfra.qizxopen.xquery.fn.Last;
import net.xfra.qizxopen.xquery.op.BasicStep;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.FunctionCall;
import net.xfra.qizxopen.xquery.op.ValueEqOp;

public class FilterExpr
extends Expression {
    public Expression source;
    public Expression[] predicates;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$fn$Position$Exec;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$fn$Last$Exec;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$SelfStep;

    public FilterExpr(Expression expression) {
        this.source = expression;
        this.predicates = new Expression[0];
    }

    public void addPredicate(Expression expression) {
        this.predicates = Expression.addExpr(this.predicates, expression);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "Filter[]");
        exprDump.display("source", this.source);
        exprDump.display("predicates", this.predicates);
    }

    public Expression child(int n) {
        return n == 0 ? this.source : (n <= this.predicates.length ? this.predicates[n - 1] : null);
    }

    public int getFlags() {
        return this.source.getFlags();
    }

    public Expression staticCheck(StaticContext staticContext) {
        this.source = staticContext.staticCheck(this.source, 0);
        staticContext.pushDotType(this.source.getType());
        int n = 0;
        while (n < this.predicates.length) {
            Expression expression = this.predicates[n] = staticContext.staticCheck(this.predicates[n], 0);
            ItemType itemType = expression.getType().getItemType();
            if (!(expression instanceof Last.Exec) && Type.NUMERIC.isSuperType(itemType)) {
                this.predicates[n] = expression.findSubExpression(class$net$xfra$qizxopen$xquery$fn$Position$Exec == null ? FilterExpr.class$("net.xfra.qizxopen.xquery.fn.Position$Exec") : class$net$xfra$qizxopen$xquery$fn$Position$Exec) != null || expression.findSubExpression(class$net$xfra$qizxopen$xquery$fn$Last$Exec == null ? FilterExpr.class$("net.xfra.qizxopen.xquery.fn.Last$Exec") : class$net$xfra$qizxopen$xquery$fn$Last$Exec) != null || expression.findSubExpression(class$net$xfra$qizxopen$xquery$op$SelfStep == null ? FilterExpr.class$("net.xfra.qizxopen.xquery.op.SelfStep") : class$net$xfra$qizxopen$xquery$op$SelfStep) != null ? staticContext.staticCheck(new ValueEqOp(expression, new FunctionCall(QName.get(Namespace.FN, "position"))), 0) : new PosTest(expression);
            }
            ++n;
        }
        if (this.source instanceof BasicStep) {
            ((BasicStep)this.source).naturalStepOrder = true;
        }
        staticContext.popDotType();
        this.type = this.source.getType();
        this.type = Type.isRepeatable(this.type.getOccurrence()) ? this.type.getItemType().star : this.type.getItemType().opt;
        return this;
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        Value value = this.source.eval(focus, evalContext);
        int n = 0;
        while (n < this.predicates.length) {
            Expression expression = this.predicates[n];
            if (expression instanceof PosTest) {
                Expression expression2 = ((PosTest)expression).index;
                value = new Index(value, (long)expression2.evalAsDouble(focus, evalContext));
            } else {
                value = expression instanceof Last.Exec ? new Last(value) : new Sequence(value, expression, evalContext);
            }
            ++n;
        }
        return value;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Slice
    extends Index {
        long indexHi;

        public Slice(Value value, long l, long l2) {
            super(value, l);
            this.indexHi = l2;
        }

        public Value bornAgain() {
            return new Slice(this.source.bornAgain(), this.index, this.indexHi);
        }

        public boolean next() throws XQueryException {
            do {
                ++this.position;
                if (this.source.next() && (long)this.position <= this.indexHi) continue;
                return false;
            } while ((long)this.position < this.index);
            this.item = this.source.asItem();
            return true;
        }
    }

    public static class Index
    extends Sequence {
        long index;

        public Index(Value value, long l) {
            super(value, null, null);
            this.index = l;
        }

        public Value bornAgain() {
            return new Index(this.source.bornAgain(), this.index);
        }

        public boolean next() throws XQueryException {
            do {
                ++this.position;
                if (this.source.next() && (long)this.position <= this.index) continue;
                return false;
            } while ((long)this.position != this.index);
            this.item = this.source.asItem();
            return true;
        }
    }

    public static class Last
    extends Sequence {
        private boolean started = false;

        public Last(Value value) {
            super(value, null, null);
        }

        public Value bornAgain() {
            return new Last(this.source.bornAgain());
        }

        public boolean next() throws XQueryException {
            if (this.started) {
                return false;
            }
            this.started = true;
            while (this.source.next()) {
                this.item = this.source.asItem();
            }
            return this.item != null;
        }
    }

    public static class Sequence
    extends GenericValue
    implements Focus {
        Value source;
        Expression predicate;
        EvalContext evalContext;
        int position = 0;
        int last = -1;

        Sequence(Value value, Expression expression, EvalContext evalContext) {
            this.evalContext = evalContext;
            this.predicate = expression;
            this.source = value;
        }

        public boolean next() throws XQueryException {
            do {
                this.evalContext.at(this.predicate);
                if (!this.source.next()) {
                    return false;
                }
                this.item = this.source.asItem();
                ++this.position;
            } while (!this.predicate.evalEffectiveBooleanValue(this, this.evalContext));
            return true;
        }

        public Value bornAgain() {
            return new Sequence(this.source.bornAgain(), this.predicate, this.evalContext);
        }

        public Item getItem() {
            return this.item;
        }

        public long getItemAsInteger() throws XQueryException {
            return this.source.asInteger();
        }

        public int getPosition() {
            return this.position;
        }

        public int getLast() throws XQueryException {
            if (this.last < 0) {
                Value value = this.source.bornAgain();
                this.last = 0;
                while (value.next()) {
                    ++this.last;
                }
            }
            return this.last;
        }
    }

    static class PosTest
    extends Expression {
        Expression index;

        PosTest(Expression expression) {
            this.index = expression;
        }

        public Expression child(int n) {
            return n == 0 ? this.index : null;
        }

        public boolean evalEffectiveBooleanValue(Focus focus, EvalContext evalContext) throws XQueryException {
            return (double)focus.getPosition() == this.index.evalAsDouble(focus, evalContext);
        }
    }
}

