/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import java.util.Arrays;
import java.util.Comparator;
import net.xfra.qizxopen.util.HTable;
import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.ArraySequence;
import net.xfra.qizxopen.xquery.dt.SingleWrappedObject;
import net.xfra.qizxopen.xquery.op.Comparison;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.LocalVariable;
import net.xfra.qizxopen.xquery.op.NodeSortExpr;
import net.xfra.qizxopen.xquery.op.ValueEqOp;
import net.xfra.qizxopen.xquery.op.ValueGeOp;
import net.xfra.qizxopen.xquery.op.ValueGtOp;
import net.xfra.qizxopen.xquery.op.ValueLtOp;

public class Join {

    public static class ITable
    extends Table {
        Entry probe = new Entry(null, null);

        ITable() {
            this.comparator = new Comparator(this){
                private final /* synthetic */ ITable this$0;
                {
                    this.this$0 = iTable;
                }

                public int compare(Object object, Object object2) {
                    try {
                        Entry entry = (Entry)object;
                        Entry entry2 = (Entry)object2;
                        return entry.key.compareTo(entry2.key, null, 0);
                    }
                    catch (Exception exception) {
                        return 0;
                    }
                }
            };
        }

        public void put(Item item, Node node) {
            this.probe.key = item;
            Entry entry = (Entry)this.get(this.probe);
            if (entry != null) {
                entry.add(node);
            } else {
                this.directPut(new Entry(item, node));
            }
        }

        Table.Entry findEntries(Item item, Comparison.Test test) {
            this.probe.key = item;
            return this.findEntries(this.probe, test);
        }

        static class Entry
        extends Table.Entry {
            Item key;

            Entry(Item item, Node node) {
                super(node);
                this.key = item;
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object object) {
                Entry entry = (Entry)object;
                return entry.key.equals(this.key);
            }
        }
    }

    public static class NTable
    extends Table {
        Entry probe = new Entry(0.0, null);

        NTable() {
            this.comparator = new Comparator(this){
                private final /* synthetic */ NTable this$0;
                {
                    this.this$0 = nTable;
                }

                public int compare(Object object, Object object2) {
                    Entry entry = (Entry)object;
                    Entry entry2 = (Entry)object2;
                    return Util.comparison(entry.key - entry2.key);
                }
            };
        }

        public void put(double d, Node node) {
            this.probe.key = d;
            Entry entry = (Entry)this.get(this.probe);
            if (entry != null) {
                entry.add(node);
            } else {
                this.directPut(new Entry(d, node));
            }
        }

        Table.Entry findEntries(double d, Comparison.Test test) {
            this.probe.key = d;
            return this.findEntries(this.probe, test);
        }

        public static class Entry
        extends Table.Entry {
            double key;

            Entry(double d, Node node) {
                super(node);
                this.key = d;
            }

            public int hashCode() {
                long l = Double.doubleToRawLongBits(this.key);
                return (int)(l ^ l >>> 32);
            }

            public boolean equals(Object object) {
                Entry entry = (Entry)object;
                return entry.key == this.key;
            }
        }
    }

    public static class STable
    extends Table {
        Entry probe = new Entry("", null);

        STable() {
            this.comparator = new Comparator(this){
                private final /* synthetic */ STable this$0;
                {
                    this.this$0 = sTable;
                }

                public int compare(Object object, Object object2) {
                    Entry entry = (Entry)object;
                    Entry entry2 = (Entry)object2;
                    return entry.key.compareTo(entry2.key);
                }
            };
        }

        public void put(String string, Node node) {
            this.probe.key = string;
            Entry entry = (Entry)this.get(this.probe);
            if (entry != null) {
                entry.add(node);
            } else {
                this.directPut(new Entry(string, node));
            }
            this.keys = null;
        }

        Table.Entry findEntries(String string, Comparison.Test test) {
            this.probe.key = string;
            return this.findEntries(this.probe, test);
        }

        public static class Entry
        extends Table.Entry {
            String key;

            Entry(String string, Node node) {
                super(node);
                this.key = string;
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object object) {
                Entry entry = (Entry)object;
                return entry.key.equals(this.key);
            }
        }
    }

    public static class Table
    extends HTable {
        Entry[] keys;
        Comparator comparator;
        int index;
        int lastIndex;

        Entry nextEntry() {
            return this.index >= this.lastIndex ? null : this.keys[this.index++];
        }

        void sortedKeys() {
            this.keys = new Entry[this.count];
            int n = 0;
            int n2 = this.hash.length;
            while (--n2 >= 0) {
                HTable.Key key = this.hash[n2];
                while (key != null) {
                    this.keys[n++] = (Entry)key;
                    key = key.next;
                }
            }
            Arrays.sort(this.keys, this.comparator);
        }

        Entry findEntries(Entry entry, Comparison.Test test) {
            this.lastIndex = 0;
            this.index = 0;
            if (test == ValueEqOp.TEST) {
                return (Entry)this.get(entry);
            }
            int n = this.locate(entry);
            if (test == ValueGtOp.TEST) {
                if (n >= this.keys.length || this.comparator.compare(entry, this.keys[n]) == 0) {
                    --n;
                }
                this.lastIndex = n + 1;
            } else if (test == ValueGeOp.TEST) {
                this.lastIndex = Math.min(this.keys.length, n + 1);
            } else if (test == ValueLtOp.TEST) {
                this.index = n + 1;
                this.lastIndex = this.keys.length;
            } else {
                if (n < this.keys.length && this.comparator.compare(entry, this.keys[n]) != 0) {
                    ++n;
                }
                this.index = n;
                this.lastIndex = this.keys.length;
            }
            return this.index < Math.min(this.lastIndex, this.keys.length) ? this.keys[this.index++] : null;
        }

        int locate(Entry entry) {
            if (this.keys == null) {
                this.sortedKeys();
            }
            int n = 0;
            int n2 = this.keys.length - 1;
            while (n <= n2) {
                int n3 = (n + n2) / 2;
                int n4 = this.comparator.compare(entry, this.keys[n3]);
                if (n4 < 0) {
                    n2 = n3 - 1;
                    continue;
                }
                if (n4 > 0) {
                    n = n3 + 1;
                    continue;
                }
                return n3;
            }
            return n;
        }

        static class Entry
        extends HTable.Key {
            Node[] nodes;
            int nodeCount;

            Entry(Node node) {
                this.nodes = new Node[]{node, null};
                this.nodeCount = 1;
            }

            void add(Node node) {
                if (this.nodeCount >= this.nodes.length) {
                    Node[] nodeArray = this.nodes;
                    this.nodes = new Node[nodeArray.length * 2];
                    System.arraycopy(nodeArray, 0, this.nodes, 0, nodeArray.length);
                }
                this.nodes[this.nodeCount++] = node;
            }

            public Node[] getNodes() {
                if (this.nodeCount == this.nodes.length) {
                    return this.nodes;
                }
                Node[] nodeArray = new Node[this.nodeCount];
                System.arraycopy(this.nodes, 0, nodeArray, 0, this.nodeCount);
                return nodeArray;
            }

            public HTable.Key duplicate() {
                System.err.println("Key.duplicate not needed");
                return null;
            }
        }
    }

    public static class GetExpr
    extends Expression {
        LocalVariable joinVar;
        Expression key;
        Comparison.Test mode;

        GetExpr(Expression expression, LocalVariable localVariable, Comparison.Test test) {
            this.key = expression;
            this.joinVar = localVariable;
            this.mode = test;
            this.type = Type.NODE.star;
        }

        public Expression child(int n) {
            return n == 0 ? this.key : null;
        }

        public void dump(ExprDump exprDump) {
            exprDump.header(this, "getJoin");
            exprDump.display("join", this.joinVar.address);
            exprDump.display("comp", this.mode.toString());
            exprDump.display("key", this.key);
        }

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            Item item = evalContext.loadLocalItem(this.joinVar.address);
            Table table = (Table)((SingleWrappedObject)item).getObject();
            ArraySequence arraySequence = null;
            int n = 0;
            Value value = this.key.eval(focus, evalContext);
            while (value.next()) {
                Table.Entry entry = null;
                entry = table instanceof STable ? ((STable)table).findEntries(value.asString(), this.mode) : (table instanceof NTable ? ((NTable)table).findEntries(value.asDouble(), this.mode) : ((ITable)table).findEntries(value.asItem(), this.mode));
                while (entry != null) {
                    if (arraySequence == null) {
                        arraySequence = new NodeSortExpr.Sequence(entry.nodes, entry.nodeCount);
                    } else {
                        arraySequence.addItems(entry.nodes, entry.nodeCount);
                    }
                    entry = table.nextEntry();
                }
                ++n;
            }
            if (n == 1 && arraySequence != null) {
                ((NodeSortExpr.Sequence)arraySequence).needsSort = false;
            }
            return arraySequence == null ? Value.empty : arraySequence;
        }
    }

    static class Maker
    extends Expression {
        Expression source;
        Expression key;
        LocalVariable tmpVar;
        Type keyType;

        Maker(Expression expression, Expression expression2, LocalVariable localVariable, Type type) {
            this.source = expression;
            this.key = expression2;
            this.tmpVar = localVariable;
            this.keyType = type;
        }

        public Expression child(int n) {
            return null;
        }

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            Value value = this.source.eval(focus, evalContext);
            long l = System.currentTimeMillis();
            Table table = null;
            while (value.next()) {
                Table table2;
                Node node = value.asNode();
                evalContext.storeLocal(this.tmpVar.address, value, true);
                Value value2 = this.key.eval(focus, evalContext);
                if (this.keyType == Type.NUMERIC) {
                    if (table == null) {
                        table = new NTable();
                    }
                    table2 = table;
                    while (value2.next()) {
                        ((NTable)table2).put(value2.asDouble(), node);
                    }
                    continue;
                }
                if (this.keyType == Type.STRING) {
                    if (table == null) {
                        table = new STable();
                    }
                    table2 = (STable)table;
                    while (value2.next()) {
                        ((STable)table2).put(value2.asString(), node);
                    }
                    continue;
                }
                if (table == null) {
                    table = new ITable();
                }
                table2 = (ITable)table;
                while (value2.next()) {
                    ((ITable)table2).put(value2.asItem(), node);
                }
            }
            return new SingleWrappedObject(table);
        }

        public void dump(ExprDump exprDump) {
            exprDump.header(this, "MakeJoin");
            exprDump.display("source", this.source);
            exprDump.display("key", this.key);
        }
    }
}

