/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.VarClause;

public class LetClause
extends VarClause {
    public LetClause(QName qName) {
        super(qName);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "Let");
        exprDump.display("variable", "$" + this.variable + " : " + this.varType + (exprDump.pretty() ? "" : " addr " + this.varDecl.address));
        exprDump.displayp(":=", this.expr);
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        return new Sequence(focus, evalContext);
    }

    public class Sequence
    extends VarClause.Sequence {
        Sequence(Focus focus, EvalContext evalContext) {
            super(focus, evalContext);
        }

        public boolean next() throws XQueryException {
            if (!this.source.next()) {
                return false;
            }
            try {
                this.context.storeLocal(LetClause.this.varDecl.address, LetClause.this.expr, LetClause.this.type, this.focus, this.context);
            }
            catch (TypeException typeException) {
                this.context.error((Expression)LetClause.this, "dynamic type mismatch on variable $" + LetClause.this.variable + " : " + typeException.getMessage() + ", expecting " + LetClause.this.varType);
            }
            return true;
        }

        public boolean nextCollection() throws XQueryException {
            if (!this.source.nextCollection()) {
                return false;
            }
            try {
                this.context.storeLocal(LetClause.this.varDecl.address, LetClause.this.expr, LetClause.this.type, this.focus, this.context);
            }
            catch (TypeException typeException) {
                this.context.error((Expression)LetClause.this, "dynamic type mismatch on 'let' variable: " + typeException.getMessage() + ", expecting " + LetClause.this.varType);
            }
            return true;
        }

        public Value bornAgain() {
            Sequence sequence = new Sequence(this.focus, this.context);
            sequence.setSource(this.source.bornAgain());
            return sequence;
        }
    }
}

