/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import java.util.Arrays;
import java.util.Comparator;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.ArraySequence;
import net.xfra.qizxopen.xquery.op.Expression;

public class NodeSortExpr
extends Expression {
    public Expression expr;

    public NodeSortExpr(Expression expression) {
        this.expr = expression;
        this.type = expression.getType();
    }

    public Expression child(int n) {
        return n == 0 ? this.expr : null;
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "Node-Sort");
        exprDump.display("expr", this.expr);
    }

    public int getFlags() {
        return 8;
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        Value value = this.expr.eval(focus, evalContext);
        return new Sequence(value);
    }

    public static class Sequence
    extends ArraySequence {
        public boolean needsSort = true;

        public Sequence(Value value) throws XQueryException {
            super(new Item[16], 0);
            while (value.next()) {
                this.addItem(value.asNode());
            }
            if (this.size == 0) {
                return;
            }
        }

        public Sequence(Node[] nodeArray, int n) {
            super(nodeArray, n);
        }

        public void sort() {
            this.pack();
            Arrays.sort(this.items, 0, this.size, new Comparator(this){
                private final /* synthetic */ Sequence this$0;
                {
                    this.this$0 = sequence;
                }

                public int compare(Object object, Object object2) {
                    Node node = (Node)object;
                    Node node2 = (Node)object2;
                    return node.orderCompare(node2);
                }
            });
            Object object = this.items[0];
            int n = Math.min(this.size, 1);
            int n2 = 1;
            while (n2 < this.size) {
                Object object2 = this.items[n2];
                if (!object2.equals(object)) {
                    object = object2;
                    this.items[n++] = object2;
                }
                ++n2;
            }
            this.size = n;
            this.needsSort = false;
        }

        public boolean next() throws XQueryException {
            if (this.needsSort || this.overflow != null) {
                this.sort();
            }
            return super.next();
        }

        public long quickCount(EvalContext evalContext) throws XQueryException {
            if (this.needsSort) {
                this.sort();
            }
            return super.quickCount(evalContext);
        }

        public Value bornAgain() {
            return new ArraySequence(this.items, this.size);
        }
    }
}

