/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.CoreDataModel;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.NamedConstructor;
import net.xfra.qizxopen.xquery.op.StringLiteral;

public class PIConstructor
extends NamedConstructor {
    public PIConstructor(String string) {
        super(null);
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            if (Character.isWhitespace(string.charAt(n))) break;
            ++n;
        }
        this.name = new StringLiteral(string.substring(0, n));
        this.contents = new Expression[]{new StringLiteral(n >= n2 ? "" : string.substring(n + 1))};
        this.type = Type.PI;
    }

    public PIConstructor(Expression expression, Expression expression2) {
        super(expression);
        if (expression2 != null) {
            this.addItem(expression2);
        }
    }

    public Node evalAsNode(Focus focus, EvalContext evalContext) throws XQueryException {
        QName qName = this.evalName(null, focus, evalContext);
        if (qName.getNamespace() != Namespace.NONE) {
            evalContext.error((Expression)this, "URI part of target is not empty in PI constructor");
        }
        CoreDataModel.PINode pINode = CoreDataModel.newPINode(qName.getLocalName());
        this.evalContents(pINode, focus, evalContext);
        return pINode;
    }

    public void evalAsEvents(XMLEventReceiver xMLEventReceiver, Focus focus, EvalContext evalContext) throws XQueryException, DataModelException {
        evalContext.at(this);
        QName qName = this.evalName(null, focus, evalContext);
        if (qName.getNamespace() != Namespace.NONE) {
            evalContext.error((Expression)this, "URI part of target is not empty in PI constructor");
        }
        xMLEventReceiver.pi(qName.getLocalName(), this.evalContents(focus, evalContext));
    }
}

