/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.SingleString;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.LocalVariable;

public class TryCatchExpr
extends Expression {
    Expression caught;
    Expression handler;
    QName errVar;
    LocalVariable varDecl;

    public TryCatchExpr(Expression expression, QName qName, Expression expression2) {
        this.caught = expression;
        this.handler = expression2;
        this.errVar = qName;
    }

    public Expression child(int n) {
        return n == 0 ? this.caught : (n == 1 ? this.handler : null);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "TryCatch");
        exprDump.display("caught", this.caught);
        exprDump.display("handler", this.handler);
    }

    public Expression staticCheck(StaticContext staticContext) {
        this.caught = staticContext.staticCheck(this.caught, 0);
        this.type = this.caught.getType();
        LocalVariable localVariable = staticContext.markLocalVariables();
        this.varDecl = staticContext.defineLocalVariable(this.errVar, Type.STRING, this);
        this.handler = staticContext.staticCheck(this.handler, 0);
        staticContext.popLocalVariables(localVariable);
        this.type = this.type.unionWith(this.handler.getType());
        return this;
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        evalContext.at(this);
        try {
            return this.caught.eval(focus, evalContext);
        }
        catch (EvalException evalException) {
            evalContext.storeLocal(this.varDecl.address, new SingleString(evalException.getMessage()), false);
            return this.handler.eval(focus, evalContext);
        }
    }
}

