/*
 * Decompiled with CFR 0.152.
 */
package com.sun.resolver.tools;

import com.sun.resolver.Catalog;
import com.sun.resolver.CatalogManager;
import com.sun.resolver.helpers.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class CatalogResolver
implements EntityResolver,
URIResolver {
    public boolean namespaceAware = true;
    public boolean validating = false;
    private static Catalog staticCatalog = null;
    private Catalog catalog = null;

    public CatalogResolver() {
        this.initializeCatalogs(false);
    }

    public CatalogResolver(boolean privateCatalog) {
        this.initializeCatalogs(privateCatalog);
    }

    private void initializeCatalogs(boolean privateCatalog) {
        this.catalog = staticCatalog;
        if (privateCatalog || this.catalog == null) {
            try {
                String catalogClassName = CatalogManager.catalogClassName();
                if (catalogClassName == null) {
                    this.catalog = new Catalog();
                } else {
                    try {
                        this.catalog = (Catalog)Class.forName(catalogClassName).newInstance();
                    }
                    catch (ClassNotFoundException cnfe) {
                        Debug.message(1, "Catalog class named '" + catalogClassName + "' could not be found. Using default.");
                        this.catalog = new Catalog();
                    }
                    catch (ClassCastException cnfe) {
                        Debug.message(1, "Class named '" + catalogClassName + "' is not a Catalog. Using default.");
                        this.catalog = new Catalog();
                    }
                }
                this.catalog.setupReaders();
                if (!privateCatalog) {
                    this.catalog.loadSystemCatalogs();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!privateCatalog && this.catalog != null && CatalogManager.staticCatalog()) {
            staticCatalog = this.catalog;
        }
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public String getResolvedEntity(String publicId, String systemId) {
        String resolved = null;
        if (this.catalog == null) {
            Debug.message(1, "Catalog resolution attempted with null catalog; ignored");
            return null;
        }
        if (systemId != null) {
            try {
                resolved = this.catalog.resolveSystem(systemId);
            }
            catch (MalformedURLException me) {
                Debug.message(1, "Malformed URL exception trying to resolve", publicId);
                resolved = null;
            }
            catch (IOException ie) {
                Debug.message(1, "I/O exception trying to resolve", publicId);
                resolved = null;
            }
        }
        if (resolved == null) {
            if (publicId != null) {
                try {
                    resolved = this.catalog.resolvePublic(publicId, systemId);
                }
                catch (MalformedURLException me) {
                    Debug.message(1, "Malformed URL exception trying to resolve", publicId);
                }
                catch (IOException ie) {
                    Debug.message(1, "I/O exception trying to resolve", publicId);
                }
            }
            if (resolved != null) {
                Debug.message(2, "Resolved public", publicId, resolved);
            }
        } else {
            Debug.message(2, "Resolved system", systemId, resolved);
        }
        return resolved;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        String resolved = this.getResolvedEntity(publicId, systemId);
        if (resolved != null) {
            try {
                InputSource iSource = new InputSource(resolved);
                iSource.setPublicId(publicId);
                URL url = new URL(resolved);
                InputStream iStream = url.openStream();
                iSource.setByteStream(iStream);
                return iSource;
            }
            catch (Exception e) {
                Debug.message(1, "Failed to create InputSource", resolved);
                return null;
            }
        }
        return null;
    }

    public Source resolve(String href, String base) throws TransformerException {
        String uri = href;
        String fragment = null;
        int hashPos = href.indexOf("#");
        if (hashPos >= 0) {
            uri = href.substring(0, hashPos);
            fragment = href.substring(hashPos + 1);
        }
        String result = null;
        try {
            result = this.catalog.resolveURI(href);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (result == null) {
            try {
                URL url = null;
                if (base == null) {
                    url = new URL(uri);
                    result = url.toString();
                } else {
                    URL baseURL = new URL(base);
                    url = href.length() == 0 ? baseURL : new URL(baseURL, uri);
                    result = url.toString();
                }
            }
            catch (MalformedURLException mue) {
                String absBase = this.makeAbsolute(base);
                if (!absBase.equals(base)) {
                    return this.resolve(href, absBase);
                }
                throw new TransformerException("Malformed URL " + href + "(base " + base + ")", mue);
            }
        }
        Debug.message(2, "Resolved URI", href, result);
        SAXSource source = new SAXSource();
        source.setInputSource(new InputSource(result));
        return source;
    }

    private String makeAbsolute(String uri) {
        if (uri == null) {
            uri = "";
        }
        try {
            URL url = new URL(uri);
            return url.toString();
        }
        catch (MalformedURLException mue) {
            String dir = System.getProperty("user.dir");
            String file = "";
            file = dir.endsWith("/") ? "file://" + dir + uri : "file://" + dir + "/" + uri;
            try {
                URL fileURL = new URL(file);
                return fileURL.toString();
            }
            catch (MalformedURLException mue2) {
                return uri;
            }
        }
    }
}

