/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.dm;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.xml.sax.InputSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.XMLReader;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import javax.xml.parsers.*;

import com.sun.resolver.Catalog;
import com.sun.resolver.CatalogManager;
import com.sun.resolver.tools.CatalogResolver;

/**
 *	Utility for document parsing and data model building.
 *	<p>Uses the Sun XML Catalog Resolver.
 */
public class DocumentParser 
{
    protected SAXParserFactory factory;
    protected EntityResolver entityResolver;
    final static String SAXLEX= "http://xml.org/sax/properties/lexical-handler";

    public DocumentParser() {
	init();
    }

    protected void init() {
	factory = SAXParserFactory.newInstance();
	factory.setNamespaceAware(true);

	// an absurdity in Crimson:
	System.setProperty("entityExpansionLimit", "1000000000");
	//
	try {
	    Class cls = Class.forName("com.sun.resolver.tools.CatalogResolver");
	    CatalogManager.ignoreMissingProperties(true);

	    entityResolver = (EntityResolver) cls.newInstance();
	}
	catch (Exception e) { // just keep silent  
	}
    }

    public XMLReader newParser() throws SAXException {
        try {
	    // Create a new JAXP SAXParser
	    SAXParser saxParser = factory.newSAXParser();
	    return saxParser.getXMLReader();
        }
        catch (ParserConfigurationException pce) {
            //pce.printStackTrace();
	    throw new SAXException("cannot create parser", pce); // can happen?
        }
    }

    /**
     *	Simple document parsing.
     *	@param source the SAX InputSource.
     *	@return the document-node (root) of the parsed document.
     */
    static public Node parse( InputSource source )
	throws SAXException, IOException {
	DocumentParser parser = new DocumentParser();
	IDocument doc = new IDocument();
        parser.parseDocument( source, doc );
	FONIDM dm = new FONIDM(doc);
	return dm.documentNode();
    }

    /**
     *	Simple document parsing (no caching). Helper method.
     */
    public FONIDocument parseDocument( URL url )
	throws org.xml.sax.SAXException, IOException
    {
	InputStream in = url.openStream();
	InputSource source = new InputSource(in);
	source.setSystemId(url.toExternalForm());

	FONIDocument parsed = null;
	try {
	    parsed = parseDocument(source);
	} finally {
	    in.close();
	}
	return parsed;
    }

    /**
     *	Simple document parsing.
     */
    public FONIDocument parseDocument( InputSource source )
	throws SAXException, IOException {
	IDocument doc = new IDocument();
        parseDocument( source, doc );
	return doc;
    }

    /**
     *	Simple document parsing.
     */
    public void parseDocument( InputSource source, FONIWriter output )
	throws SAXException, IOException {
        parseDocument( source, output, newParser() );
    }

    /**
     *	Simple document parsing, with a specified XML Reader.
     */
    public void parseDocument( InputSource input, FONIWriter output,
			       XMLReader saxReader )
	throws SAXException, IOException {
	try {
	    saxReader.setProperty(SAXLEX, output);
	} catch (Exception lex) {
	    
	}
	if (entityResolver != null) 
	    saxReader.setEntityResolver(entityResolver);
	else
	    saxReader.setEntityResolver(output);
	saxReader.setDTDHandler(output);
	saxReader.setContentHandler(output);
	saxReader.setErrorHandler(output);

	long T0 = System.currentTimeMillis();
	saxReader.parse(input);
	
    }
} 
