/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.dm;

import net.xfra.qizxopen.util.QName;

/**
 *	Logical OR of two NodeTests.	
 */
public class UnionNodeTest implements NodeTest
{
    public NodeTest t1, t2;

    public  UnionNodeTest( NodeTest t1, NodeTest t2 ) {
        this.t1 = t1; this.t2 = t2;
    }

    public String toString() {
	return "UnionTest( "+t1+", "+t2+")";
    }

    public int getNodeKind() {
	int k1 = t1.getNodeKind();
	return k1 == t2.getNodeKind()? k1 : -1;
    }

    public boolean staticallyCheckable() {
	return false;
    }

    public boolean accepts( int nodeKind, QName nodeName ) {
	return t1.accepts(nodeKind, nodeName) || t2.accepts(nodeKind, nodeName);
    }

    public boolean needsNode() { return false; }

    public boolean accepts( Node node ) {
	return accepts(node.getNature(), node.getNodeName());
    }
} // end of class CompositeNodeTest

