/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.XMLSerializer;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;

import java.io.FileOutputStream;

/**
 *  Implementation of function x:serialize().
 *
 *  Options are defined by the attributes of a node passed as optional second argument:
 *  <pre>
 *  output  CDATA
 *  method (XML | XHTML | HTML | TEXT)
 *  encoding CDATA
 *  omit-xml-declaration (yes | no)
 *  standalone (yes | no)
 *  doctype-system
 *  doctype-public
 *  escape-uri-attributes (yes | no)
 *  include-content-type (yes | no)
 *  indent (yes | no)
 *  indent-value integer
 *  </pre>
 */
public class XfnSerialize extends Function {

    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "serialize");
    static Prototype[] protos = { 
        new Prototype(qfname, Type.STRING.opt, Exec.class)
	    .arg("node", Type.NODE),
        new Prototype(qfname, Type.STRING.opt, Exec.class)
	    .arg("node", Type.NODE).arg("options", Type.ELEMENT)
    };

    public Prototype[] getProtos() { return protos; }

    private static String getOption( Node options, String name ) {
	if(options == null)
	    return null;
	Node attr = options.getAttribute(QName.get(name));
	return attr == null ? null : attr.getStringValue();
    }

    public static class Exec extends Function.OptStringCall {

        public String evalAsOptString(Focus focus, EvalContext context)
	    throws XQueryException {
            context.at(this);

	    Node options = args.length < 2 ? null : args[1].evalAsNode(focus, context);
	    // special option file/output
	    String output = getOption(options, "file");
	    if(output == null)
		output = getOption(options, "output");

	    XMLSerializer serial = new XMLSerializer();
	    try {
		// other options:
		if(options != null) {	
		    Value optlist = options.getAttributes();
		    for(; optlist.next(); ) {
			Node attr = optlist.asNode();
			String option = attr.getNodeName().getLocalName();
			if(!option.equals("output") && !option.equals("file"))
			    serial.setOption( option, attr.getStringValue());
		    }
		} 
		// use in-scope NS as hints for xmlns:* generation:
		serial.definePrefixHints( context.getStaticContext().getInScopeNS() );

		serial.reset();	// mandatory
		FileOutputStream outs = null;
		if( output != null )
		    serial.setOutput(outs = new FileOutputStream(output),
				     serial.getEncoding());
		else	// FIXME? encoding cannot be specified on default output
		    serial.setOutput(context.getDefaultOutput());

		args[0].evalAsEvents(serial, focus, context);
		serial.terminate();

		if(outs != null)
		    outs.close();
		else
		    context.getDefaultOutput().flush();
	    }
	    catch (EvalException e) {
		throw e;	// just to avoid the next catch
	    }
	    catch (Exception e) {
		//e.printStackTrace();
		context.error(this, new EvalException("serialization error: "+
						      e.toString(), e));
		return null;
	    }
	    return output;
        }
    }
}
