/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.StringLiteral;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.dm.DataModelException;

/**
 *	Returns a string representing a XQuery script as an element structure where
 *	each token is wrapped in an element.
 */
public class XfnSyntaxColoring extends Function
{
    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "syntax-coloring");
    static Prototype[] protos = { 
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	    .arg("query", Type.STRING).arg("options", Type.NODE.star)
    };
    public Prototype[] getProtos() { return protos; }

    final static String[] tokenTypes = { 
	null, "tag", "s", "nu", "tx", "op", "nm", "k", "com", "prag", "fun" };

    public static class Exec extends Function.TreeCall {

        public void evalAsEvents(XMLEventReceiver output, Focus focus, EvalContext context)
	    throws XQueryException {
            context.at(this);
	    String code = args[0].evalAsString(focus, context);
	    code = code.replace('\r', ' ');
	    Node options = (args.length<2)? null : args[1].evalAsOptNode(focus, context);
	    SyntaxColorer scolo = new SyntaxColorer(code);

	    QName wrapperElem = QName.get("pre");
	    QName spanElem = QName.get("span");
	    QName classAttr = QName.get("class");

	    if(options != null) {	
		for(Value list = options.getAttributes(); list.next(); ) {
		    Node attr = list.asNode();
		    String option = attr.getNodeName().getLocalName();
		    
		}
	    } 
	    try {
		output.startElement(wrapperElem);
		int prevToken = -1;
		for(int token = scolo.nextToken(); token > 0; token = scolo.nextToken()) {
		    String space = scolo.getSpace();
		    if(space != null)
			output.text(space);
		    if(token != prevToken) {
			if(prevToken >= 0)
			    output.endElement(spanElem);
			output.startElement(spanElem);
			output.attribute(classAttr, "xq_"+tokenTypes[token]);
			prevToken = token;
		    }
		    String value = scolo.tokenValue();
		    output.text(value);
		}
		output.endElement(spanElem);
		output.endElement(wrapperElem);
	    }
	    catch (DataModelException e) { }
	}
    }

} // end of class XfnSyntaxColoring

