/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.StringLiteral;
import net.xfra.qizxopen.xquery.dm.Node;

import net.xfra.qizxopen.util.*;

/**
 *  Implementation of function x:ulike (similar to x:like but
 *  with Unix/glob style patterns).
 */
public class XfnUlike extends XfnLike {

    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "ulike");
    static Prototype[] protos = { 
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	.arg("pattern", Type.STRING).arg("context", Type.NODE.star),
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	    .arg("pattern", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends XfnLike.Exec {

	protected StringPattern preparePattern( String pattern, EvalContext context) {
	    if(context == previousContext && pattern.equals(previousPattern))
		return previousPattern;
	    previousPattern = new GlobPattern(pattern);
	    previous = pattern;
	    previousContext = context;
	    return previousPattern;
	}
    }
}
