/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

/**
 *    Unix-style globbing (SQL-LIKE mapped to this pattern by converting characters).
 */
public class GlobPattern extends StringPattern
{
    public GlobPattern(String pattern) {
	this(pattern.toCharArray(), pattern.length());
    }

    public GlobPattern(char[] pattern, int length) {
	super(pattern, length);
	exact = false;
    }

    public boolean matches(String string) {
	return matches(string.toCharArray());
    }

    public boolean matches(char[] string) {
	
	return glob(string, 0, pattern, 0);
    }

    public String fixedPrefix() {
	return "";	// TODO optimize
    }

    public String toString() {
	return "Glob "+new String(pattern);
    }

    public static boolean glob(char[] string, int ps, char[] pattern, int pp) {
	int slen = string.length;
	int plen = pattern.length;

	for( ; ; ++pp, ++ps) {
	    // See if we're at the end of both the pattern and the string.
	    // If so, we succeeded.  If we're at the end of the pattern
	    // but not at the end of the string, we failed.
	    if (pp == plen)
		return (ps == slen);
		
	    if (ps == slen && pattern[pp] != '*')
		return false;
		
	    // Check for a "*" as the next pattern character.  It matches
	    // any substring.  We handle this by calling ourselves
	    // recursively for each postfix of string, until either we
	    // match or we reach the end of the string.
	    if (pattern[pp] == '*') {
		++ pp;
		if (pp == plen)
		    return true;	// no need to go on

		for( ; ; ps ++) {
		    if (glob(string, ps, pattern, pp))
			return true;
		    if (ps == slen)
			return false;
		}
	    }
		
	    // Check for a "?" as the next pattern character.  It matches
	    // any single character.
	    if (pattern[pp] == '?')
		continue;
	    else if (pattern[pp] == '[') {
		++ pp;
		boolean negated = false;
		if(pp < plen && pattern[pp] == '^') {
		    negated = true; ++ pp;
		}
		for(;;) {
		    if (pattern[pp] == ']' || pp >= plen) {
			// end of range reached: success if negated, else failure
			if(!negated)
			    return false;
			break;
		    }
		    else if (pattern[pp] == string[ps]) {
			if(negated)
			    return false;
			break;
		    }
		    if (pattern[pp + 1] == '-' && pp < plen - 2) {
			if (pattern[pp] <= string[ps] && string[ps] <= pattern[pp+2]) {
			    if(negated)
				return false;
			    break;
			}
			pp += 2;
		    }
		    ++ pp;
		}
		// in case of match, skip remainder of [char set]
		while (pp < plen && pattern[pp] != ']') {
		    ++ pp;
		}
		continue;
	    }
	    /* If the next pattern character is '\', just it strip off
	     * so we do exact matching on the character that follows.
	     */
	    if (pattern[pp] == '\\')
		if (++pp == plen)
		    return false;
		
		
	    // There's no special character.  Just make sure that the next
	    // characters of each string match.
	    if (pattern[pp] != string[ps])
		return false;
	}
    }

    static public void main( String args[] )
    {
        try {
	    char[] s = args[0].toCharArray();
	    char[] p = args[1].toCharArray();
            boolean res = glob(s, 0, p, 0);
	    System.out.println(" "+res);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
