/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.util;

import java.io.IOException;

/**
 *	An abstract set of identifiers (positive integers). 
 */
public abstract class IdSet
{
    /**
     *	Identifier containment test.
     */
    public abstract boolean test( int id );

    /**
     *	Iteration mechanism: returns the first id in the set that is >= to argument.
     *	@return -1 if no next id.
     */
    public abstract int  getNext( int id );

    public boolean isEmpty() {
	return getNext(0) < 0;
    }
    /**
     *	returns true if the intersection of the two sets is not empty.
     */
    public boolean intersects( IdSet that ) {
	return IntersectionIdSet.getNext(0, this, that) >= 0;
    }

    public abstract IdSet copy();
}
