/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

/**
 *	Measures the progress of a time-consuming task
 *	and optionally allows to cancel it.
 */
public interface ProgressHandler
{
    /**
     *	Starts a new task (name and arguments are application dependent).
     */
    void startTask(String taskName, String taskArgument);
    /**
     *	signals progress as a fraction between 0 and 1.
     */
    void fractionDone(double fraction);
    /**
     *	signals progress as an estimated size:
     *	it is up to the client code to convert it to a fraction.
     */
    void quantityDone(long size);
    /**
     *	Signals end of task.
     */
    void finishTask();

    /**
     *	Tests whether the task is cancelled.
     */
    boolean isCancelled();
}
