/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

import java.util.Random;

/**
 *  Utilities for random generation of data. Used as XQuery Java extension functions.
 */
public class RandomGene
{
    static Random rand = new Random();

    /**
     *	random selector of an object in a list.
     */
    public static RandomSelector selector(Object[] data) {
	return new RandomSelector(data);
    }
    public static Object select(RandomSelector selector) {
	return selector.select();
    }
    public static Object xselect(RandomSelector selector, double decay) {
	return selector.xselect(decay);
    }

    /**
     *	Simple id generator.
     */
    public static IdGenerator generator() {
	return new IdGenerator();
    }
    public static int idGenerate(IdGenerator generator) {
	return ++ generator.id;
    }
    
    /**
     *	Returns a number between 1 and N, with decaying probability
     */
    public static int random(long range) {
	return rand.nextInt( (int) range);
    }
    /**
     *	Returns a number between 1 and N, with decaying probability
     */
    public static int xrandom(double decay) {
	int r = 1;
	while(rand.nextDouble() < decay)
	    ++ r;
	return r;
    }

    
    public static class IdGenerator {
	int id;
    }

    public static class RandomSelector
    {
	Object[] data;

	RandomSelector(Object[] data) {
	    this.data = data;
	}

	Object select() {
	    return data[ rand.nextInt(data.length) ];
	}
	Object xselect(double decay) {
	    for(int tries = 3; --tries >= 0;) {
		int x = xrandom(decay);
		if(x <= data.length)
		    return data[ x - 1 ];
	    }
	    return data[0];
	}
    }
}
