/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util.time;

/**
 *	Representation of a Time value.
 *	
 *	@author Xavier Franc. Most of this code borrowed from XMLmind XML Editor (courtesy
 *	of H. Shafie), and adapted (or botched-up).
 */
public class Time extends DateTimeBase
{
    public Time( int hour, int minute, double second, int tzSign, int tzHour, int tzMinute )
	throws DateTimeException {
        super( EPOCH, 1, 1, hour, minute, second, tzSign, tzHour, tzMinute );
    }

    public Time( DateTimeBase dt ) throws DateTimeException {
        this( dt.hour, dt.minute, dt.second, dt.tzSign, dt.tzHour, dt.tzMinute );
    }

    public DateTimeBase parse( String that, int implicitTimeZone ) throws DateTimeException {
	return parseTime(that, implicitTimeZone);
    }

    public static Time parseTime( String s, int implicitTimeZone )
	throws DateTimeException {
	int hour;
	int minute;
	double second;
	int[] tz = new int[3];

	int charCount = s.length();
	int pos = 0;
	if (pos+2 >= charCount || s.charAt(pos+2) != ':')
	    throw new DateTimeException("invalid time syntax", s);
	hour = parseInt(s, pos, pos+2);
	pos += 3;

	if (pos+2 >= charCount || s.charAt(pos+2) != ':')
	    throw new DateTimeException("invalid time syntax", s);
	minute = parseInt(s, pos, pos+2);
	pos += 3;

	int tzPos = parseTimeZone(s, pos, tz);
	if (tzPos < pos+2)
	    throw new DateTimeException("invalid time syntax", s);

	second = parseDouble(s, pos, tzPos);

	Time result = new Time(hour, minute, second, tz[0], tz[1], tz[2]);
	if(tz[0] == 0)
	    result.forceTimeZone( implicitTimeZone );
	return result;
    }

    public String toString() {
	StringBuffer buffer = new StringBuffer();

	appendPadded( hour, 2, buffer);
	buffer.append(':');
	appendPadded( minute, 2, buffer);
	buffer.append(':');
	appendPadded( second, 2, buffer);

	appendTimeZone( tzSign, tzHour, tzMinute, buffer );

	return buffer.toString();
    }

} // end of class Time

