/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery;

import net.xfra.qizxopen.xquery.op.Expression;

/**
 *	XQuery Runtime exception.
 *	Holds the evaluation context valid at the time of the error.
 */
public class EvalException extends XQueryException
{
    public EvalException( String reason ) {
        super(reason);
    }
    
    public EvalException( String reason, Exception cause ) {
        super(reason);
        initCause(cause);
    }
    
    EvalContext context;
    
    public EvalContext getContext() {
        return context;
    }
    
    public void setContext(EvalContext ctx) {
        context = ctx;
    }
    
    public void  printStack(Log log, int maxDepth) {
        if(context == null) {
            System.err.println("*** OOPS: no context for error: "+this);
            return;
        }
        Expression point = context.getCurrentLocation();
        if(point != null)
            log.error( point.module, point.location, getMessage());
        context.printStack(log, maxDepth);
    }
    
} // end of class EvalException

