/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dm;

import net.xfra.qizxopen.xquery.*;
import java.util.HashSet;

/**
 *	Node Filter removing duplicates.
 */
public class DistinctNodeSequence extends NodeSequenceBase
{
    Value source;
    Node  node;
    HashSet seenSet = new HashSet();

    public DistinctNodeSequence( Value source ) {
        this.source = source;
    }

    public Node  asNode() throws TypeException {
	return node;
    }

    public boolean next() throws XQueryException {
	for(; source.next(); ) {
	    node = source.asNode();
	    // equals and HashCode on Node are based on identity.
	    if( !seenSet.contains(node) ) {
		seenSet.add(node);
		return true;
	    }
	}
	return false;
    }

    public Value  bornAgain() {
	return new DistinctNodeSequence( source.bornAgain() );
    }
    
} // end of class DistinctNodeSequence

