/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dm;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.dm.NodeTest;

/**
 *	A Data-Model Node that is also a XPath/XQuery Item.
 *	
 */
public interface Node extends Item, net.xfra.qizxopen.dm.Node 
{
    Node getDocument();

    Node getParent();

    Node getAttribute( QName name );

    Value getChildren();

    Value getAttributes();

    Value getNamespaces( boolean inScope );

    /**
     *	Returns an iterator on ancestors that match the node test.
     *  @param nodeTest concrete classes are BaseNodeTest(node-kind?, nsuri?, ncname?),
     *  UnionNodeTest, DocumentTest. 
     */
    Value getAncestors( NodeTest nodeTest );

    Value getAncestorsOrSelf( NodeTest nodeTest );

    /**
     *	Returns a sequence of length 1 (if the parent matches the nodeTest) else 0.
     */
    Value getParent( NodeTest nodeTest );

    Value getChildren( NodeTest nodeTest );

    Value getDescendants( NodeTest nodeTest );

    Value getDescendantsOrSelf( NodeTest nodeTest );

    Value getAttributes( NodeTest nodeTest );

    Value getFollowingSiblings( NodeTest nodeTest );
    /**
     *	Preceding siblings in document order.
     */
    Value getPrecedingSiblings( NodeTest nodeTest );

    Value getFollowing( NodeTest nodeTest );
    /**
     *	Preceding nodes in document order.
     */
    Value getPreceding( NodeTest nodeTest );

} // end of interface Node

