/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.util.time.*;

import java.util.Date;

public class MomentType extends AtomicType {

    public String getShortName() {
        return "moment";
    }

    public Value  convertFromObject( Object object ) {
	Date date = (Date) object;
	return new SingleMoment( DateTime.fromDate(date, 0), Type.DATE_TIME );
    }

    public Object convertToObject( Expression expr, Focus focus, EvalContext context )
	throws XQueryException {
	Item v = expr.evalAsItem(focus, context);
	DateTimeBase dt = ((MomentValue) v).getValue();
	return new Date( (long) (1000 * dt.getSecondsFromEpoch()) );
    }

}
