/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.dm.FONIDM;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dm.FONIDataModel;
import net.xfra.qizxopen.xquery.op.Expression;

/**
 *	Represents any node type.
 */
public class NodeType extends ItemType
{
    public NodeTest nodeTest;

    public NodeType( NodeTest nodeTest ) {
        this.nodeTest = nodeTest;
        parent = Type.NODE;	// unless set by class Type
    }
    
    public boolean accepts( Type valueType ) {
        valueType = valueType.getItemType();
        if(!(valueType instanceof NodeType))
            return false;
        //TODO: too lax 
	NodeTest otherTest = ((NodeType) valueType).nodeTest;
        return nodeTest == null ||
	       otherTest != null && nodeTest.accepts(otherTest.getNodeKind(), null);
    }
    
    public boolean acceptsItem( Item item ) {
        
        if(!item.isNode())
            return false;
        try {
            Node node = item.asNode();	// throws exception if not a node
            
            return nodeTest == null || nodeTest.accepts(node);
        }
        catch (XQueryException e) {
            e.printStackTrace(); return false;	// cannot happen due to check above
        }
    }
    
    public void dump( ExprDump d ) {
        d.println("NodeType");
        d.display("test", nodeTest == null ? null : nodeTest.toString());
    }
    
    public String toString(StaticContext ctx) {
        return toString();
    }
    
    public String toString() {
        int kind = nodeTest == null ? -1 : nodeTest.getNodeKind();
        if(kind < 0)
            return "node()";
        //return nodeKind(kind) + "("+ nodeTest + ")";
        return nodeKind(kind) + "()";
    }
    
    public String getShortName() {
        return "node";
    }
    
    public static String  nodeKind( int kind ) {
	switch(kind) {
	    case Node.DOCUMENT:
		return "document";
	    case Node.ELEMENT:
		return "element";
	    case Node.TEXT:
		return "text";
	    case Node.COMMENT:
		return "comment";
	    case Node.PROCESSING_INSTRUCTION:
		return "processing-instruction";
	    case Node.ATTRIBUTE:
		return "attribute";
	    case Node.NAMESPACE:
		return "namespace";
	    default:
		return "illegal node";
	}
    }

    static public ItemType  getTypeByKind( int kind ) {
	switch(kind) {
	    case Node.DOCUMENT:
		return Type.DOCUMENT;
	    case Node.ELEMENT:
		return Type.ELEMENT;
	    case Node.ATTRIBUTE:
		return Type.ATTRIBUTE;
	    case Node.TEXT:
		return Type.TEXT;
	    case Node.PROCESSING_INSTRUCTION:
		return Type.PI;
	    case Node.COMMENT:
		return Type.COMMENT;
	    case Node.NAMESPACE:
		return Type.NAMESPACE;
	    default:
		throw new RuntimeException("wrong node kind "+kind);
	}
    }

    public Value  convertFromObject( Object object ) {
	if(!(object instanceof Node)) {
	    // maybe a net.xfra.qizxopen.dm.Node coming from a XLib extension function:
	    if(object instanceof FONIDM.BaseNode)
		object = FONIDataModel.convertBasicNode( (FONIDM.BaseNode) object );
	    else return new SingleWrappedObject(object);	// fallback
	}
	return new SingleNode((Node) object);
    }

    public Object convertToObject( Expression expr, Focus focus, EvalContext context )
	throws XQueryException {
	return expr.evalAsNode(focus, context);
    }

    public Value  convertFromArray( Object object ) {
	Node[] result = (Node[]) object;
	return new ArraySequence(result, result.length);
    }

    public Object convertToArray( Value value ) throws XQueryException {
	return ArraySequence.expandNodes( value );
    }
} // end of class NodeType

