/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.Duration;
import net.xfra.qizxopen.xquery.*;

/**
 *	A scalar Duration value.
 */
public class SingleDuration extends DurationValue
{
    private Duration value;
    private boolean started = false;

    public SingleDuration( Duration value ) {
	this(value, Type.DURATION);
    }

    public SingleDuration( Duration value, ItemType subType ) {
	this.value = value;
	itemType = subType;
    }

    public boolean next() {
	return started ? false : (started = true);
    }

    public Value  bornAgain() {
	return new SingleDuration(value, itemType);
    }

    public Duration getValue() {
	return value;
    }

} // end of class SingleDuration
