/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dm.NodeSequenceBase;

/**
 *	
 */
public class SingleNode extends NodeSequenceBase
{
    private Node value;
    private boolean started = false;

    public SingleNode( Node node ) {
	value = node;
    }

    public boolean next() {
	return started ? false : (started = true);
    }

    public Value  bornAgain() {
	return new SingleNode(value);
    }

    public Node asNode() {
	return value;
    }
} // end of class SingleNode

