/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;

/**
 *  Implementation of function fn:collection.
 */
public class Collection extends Function {

    static Prototype[] protos = { 
        Prototype.fn("collection", Type.NODE.star, Exec.class)
            .arg("srcval", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
	    String uri = args[0].evalAsOptString(focus, context);
	    if(uri == null)
		return Value.empty;
            context.at(this);
	    context.error(this, "collections not supported in this version");
	    return Value.empty;	// dummy
        }

	public int getFlags() {
	    return DOCUMENT_ORDER + SAME_DEPTH;
	}
    }
}
