/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.util.time.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleMoment;

/**
 *  Implementation of function fn:current-time.
 */
public class CurrentTime extends Function {

    static Prototype[] protos = { 
        Prototype.fn("current-time", Type.TIME, Exec.class)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    try {
		return new SingleMoment(
		    new Time(DateTimeBase.fromDate( context.getCurrentDate(),
						    context.getImplicitTimezone())),
		    Type.TIME );
	    }
	    catch(DateTimeException e) { e.printStackTrace(); return null; } // cannot happen
        }
    }
}
