/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.DurationValue;

/**
 *  Implementation of function fn:get-minute (replaces get-minute-from-***).
 */
public class GetMinute extends Function {

    static Prototype[] protos = { 
      Prototype.fn("get-minute", Type.INTEGER.opt, Exec.class).arg("op", Type.TIME.opt),
      Prototype.fn("get-minute", Type.INTEGER.opt, Exec.class).arg("op", Type.DATE_TIME.opt),
      Prototype.fn("get-minute", Type.INTEGER.opt, Exec.class).arg("op", Type.DURATION.opt)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.IntegerCall {
        public long evalAsInteger(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Item v = args[0].evalAsOptItem(focus, context);
	    if(v == null)
		throw EmptyException.allowed();
	    if(v.getType() == Type.DURATION) {
		DurationValue dv = (DurationValue) v;	
		return dv.getValue().getMinute();
	    }
	    else {
		MomentValue mv = (MomentValue) v;
		return mv.getValue().getMinute();
	    }
        }
    }
}
