/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.dt.SingleItem;
import java.text.Collator;

/**
 *  Implementation of function fn:min.
 */
public class Min extends Function {

    static Prototype[] protos = { 
        Prototype.fn("min", Type.ANY_ATOMIC_TYPE.opt, RT.class)
	 .arg("op", Type.ITEM.star), // wider than definition to avoid boring type problems
        Prototype.fn("min", Type.ANY_ATOMIC_TYPE.opt, RT.class)
	 .arg("op", Type.ITEM.star)  // wider than definition to avoid boring type problems
	 .arg("collationLiteral", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public Expression staticCheck( StaticContext context, Expression[] arguments,
				   Expression subject )	{
	Expression ex = super.staticCheck(context, arguments, subject);
	RT rt = (RT) ex;
	// change the result type to the type of the argument (may be empty -> optional)
	if(rt.args.length > 0) {	// error protection
	    ItemType argType = rt.args[0].getType().getItemType();
	    if(Type.NODE.accepts(argType) || argType == Type.UNTYPED_ATOMIC)
		argType = Type.DOUBLE;	// Nov 2003
	    rt.setType( argType.opt );
	}	
        return rt;
    }

    public static class RT extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {

	    Value v = args[0].eval(focus, context);
	    Collator collator = args.length < 2 ? 
		null : context.getCollator(args[1].evalAsString(focus, context));
            context.at(this);

	    Item result = null;
	    ItemType resultType = this.getType().getItemType();	// wanted type of result
	    for(int rank = 1 ; v.next(); ++ rank) {
		Value item = v;
		ItemType itemType = v.getType();
		if(Type.NODE.accepts(itemType) || Type.UNTYPED_ATOMIC == itemType)
		    resultType = Type.DOUBLE;	// Nov 2003
		if(itemType != resultType) {
		    item = resultType.cast(item, context);
		}
		if(result == null)
		    result = item.asAtom();
		else {
		   int cmp = item.compareTo( result, collator, 
					     context.getImplicitTimezone());
		   if(cmp == Item.INCOMPARABLE)
		       context.error(args[0], "cannot compare item at position "+rank);
		   if(cmp < 0)	// NaN are automatically discarded
		       result = item.asAtom();
		}
	    }
	    if(result == null)	
		return Value.empty;
	    if(result.getType() != resultType)
		result = resultType.cast(new SingleItem(result), context);
	    return new SingleItem(result);
	}
    }
}
