/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:normalize-space.
 */
public class NormalizeSpace extends Function {

    static Prototype[] protos = { 
        Prototype.fn("normalize-space", Type.STRING.opt, Exec.class),
        Prototype.fn("normalize-space", Type.STRING.opt, Exec.class)
            .arg("srcval", Type.STRING.opt)
    };

    public Prototype[] getProtos() { return protos; }

    static String normalize( String src ) {
	StringBuffer buf = new StringBuffer();
	boolean pendingSpace = false;

	for(int i = 0, L = src.length(); i < L; i++) {
	    char c = src.charAt(i);
	    if(Character.isWhitespace(c)) {
		if(buf.length() > 0)
		    pendingSpace = true;
	    }
	    else {
		if(pendingSpace)
		    buf.append(' ');
		buf.append(c);
		pendingSpace = false;
	    }
	}
	return buf.toString();
    }

    public static class Exec extends Function.OptStringCall {

        public String evalAsOptString(Focus focus, EvalContext context) throws XQueryException {
	    String src = args.length == 0 ?
		focus.getItem().asString() : args[0].evalAsOptString(focus, context);
            context.at(this);
	    return src == null ? "" : normalize(src);
        }
    }
}
