/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.xquery.*;

/**
 *  Implementation of function fn:one-or-more.
 */
public class OneOrMore extends Function {

    static Prototype[] protos = { 
        Prototype.fn("one-or-more", Type.ITEM.plus, Exec.class)
            .arg("srcval", Type.ITEM.star)
    };

    public Prototype[] getProtos() { return protos; }


    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Value value = args[0].eval(focus, context);
	    try {
		value = Type.ITEM.plus.check(value);
	    } catch (TypeException err) {
		context.error(this, err);
	    }
	    return value;
        }
    }
}
