/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;

/**
 *  Implementation of function fn:round-half-to-even.
 */
public class RoundHalfToEven extends Function {

    static Prototype[] protos = { 
        Prototype.fn("round-half-to-even", Type.NUMERIC.opt, Exec.class)
            .arg("srcval", Type.NUMERIC.opt),
        Prototype.fn("round-half-to-even", Type.NUMERIC.opt, Exec.class)
            .arg("srcval", Type.NUMERIC.opt).arg("precision", Type.INTEGER)
    };
    public Prototype[] getProtos() { return protos; }

    public Expression staticCheck(StaticContext ctx, Expression[] args, Expression loc) {
	Exec rt = (Exec) super.staticCheck(ctx, args, loc);
	// change the result type to the type of the argument
	ItemType argType = rt.args[0].getType().getItemType();
	rt.setType( argType.opt );
        return rt;
    }

    public static class Exec extends Function.DoubleCall {
        public double evalAsDouble(Focus focus, EvalContext context)
	    throws XQueryException {
            context.at(this);
            double d = args[0].evalAsOptDouble(focus, context), prec = 0;
	    if(args.length == 2)
		prec = args[1].evalAsInteger(focus, context);
	    prec = Math.pow(10, prec);
	    return Math.round(d * prec) / prec ;
        }
    }
}
