/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
//import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of function fn:string-join.
 */
public class StringJoin extends Function {

    static Prototype[] protos = { 
        Prototype.fn("string-join", Type.STRING, Exec.class)
            .arg("op1", Type.STRING.star) .arg("op2", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }


    public static class Exec extends Function.StringCall {

        public String evalAsString(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Value v = args[0].eval(focus, context);
	    String sep = args[1].evalAsString(focus, context);
	    StringBuffer buf = new StringBuffer();
	    boolean first = true;
	    for(; v.next(); ) {
		if(!first)
		    buf.append(sep);
		first = false;
		buf.append(v.asString());
	    }
	    return buf.toString();
        }
    }
}
