/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;

/**
 *  Implementation of function fn:trace.
 */
public class Trace extends Function {

    static Prototype[] protos = { 
        Prototype.fn("trace", Type.NONE, Exec.class)
            .arg("value", Type.ITEM.star)
	    .arg("label", Type.STRING),
        Prototype.fn("trace", Type.NONE, Exec.class)	// just print stack
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    if(args.length == 0) {
		context.printStack(context.getLog(), 12);
		return Value.empty;
	    }
	    Value v = args[0].eval(focus, context);
	    String label = args[1].evalAsString(focus, context);
	    Log log = context.getLog();
	    log.trace( module, location, label, null );
	    int itemX = 0;
	    for(; v.next(); ) {
		++ itemX;
		String disp = itemX +") "+ v.getType() + " ";
		if(v.isNode()) {
		    Node n = v.asNode();
		    disp += n.getNodeKind();
		    if(n.getNodeName() != null)
			disp += ", name: " + n.getNodeName();
		}
		else disp += v.asString();
		log.info( disp );
	    }
	    return v.bornAgain();
        }
    }
}
