/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;

/**
 *  Implementation of attribute constructors. 
 */
public class AttributeConstructor extends NamedConstructor {

    // temporary for NS resolution:
    public String value, prefix;

    public AttributeConstructor( Expression name ) {
        super( name );
	type = Type.ATTRIBUTE;
    }

    public void dump( ExprDump d ) {
	d.header( this, "attribute-constructor" );
        d.display("name", name);
        d.display("contents", contents);
    }

    public Node evalAsNode( Focus focus, EvalContext context ) throws XQueryException {
        QName qname = evalName(null, focus, context);
	Node node = CoreDataModel.newAttribute(qname);
	evalContents( node, focus, context );
	return node;
    }

    public void evalAsEvents( XMLEventReceiver output, Focus focus, EvalContext context )
	throws XQueryException, DataModelException  {
	context.at(this);
        QName qname = evalName(output, focus, context);
	output.attribute( qname, evalContents(focus, context) );
    }
}
