/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleBoolean;

/**
 *	Superclass of boolean expressions.
 */
public abstract class BooleanExpression extends Expression
{
    // redefined above the 'abstract' evalAsBoolean
    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	return new SingleBoolean( evalAsBoolean( focus, context ) );
    }

    public abstract boolean evalAsBoolean(Focus focus, EvalContext context) throws XQueryException;

    public boolean evalAsEffectiveBoolean(Focus focus, EvalContext context) throws XQueryException {
	return evalAsBoolean( focus, context );
    }
} // end of class Expression
