/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleDouble;

/**
 *	Superclass of expressions returning double.
 *	
 */
public abstract class DoubleExpression extends Expression
{
    // redefined above the abstracted evalAsDouble
    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	return new SingleDouble( evalAsDouble( focus, context ) );
    }

    public abstract double evalAsDouble( Focus focus, EvalContext context) throws XQueryException;

} // end of class DoubleExpression

