/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.dt.GenericValue;

/**
 *  class ExceptOp: 
 * 
 */
public class ExceptOp extends NodeExpression {

    public ExceptOp( Expression expr1, Expression expr2 ) {
	super(expr1, expr2);
    }

    public void dump( ExprDump d ) {
	d.header( this, "ExceptOp" );
        d.display("expr1", expr1);
        d.display("expr2", expr2);
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	context.at(this);
	return new Sequence( expr1.eval(focus, context), expr2.eval(focus, context));
    }

    public class Sequence  extends GenericValue
    {
	Value  s1, s2;
	Node n1, n2;	// current nodes

	Sequence( Value s1, Value s2 ) throws XQueryException {
	    this.s1 = s1; this.s2 = s2; 
	    n1 = s1.next() ? s1.asNode() : null;
	    n2 = s2.next() ? s2.asNode() : null;
	}

	// assumes that s1 and s2 are in doc order
	public boolean next() throws XQueryException {

	    for (;;) {
		if(n1 == null)
		    return false;
		// we have an item in s1:
		int cmp = n2 == null ? -1 : n1.orderCompare(n2);
		item = n1;
		if(cmp <= 0) {
		    n1 = s1.next() ? s1.asNode() : null;
		    if(cmp < 0)
			return true;
		}
		if(cmp >= 0) {
		    n2 = s2.next() ? s2.asNode() : null;
		}
	    }
	}

	public Value  bornAgain() {
	    try {
		return new Sequence(s1.bornAgain(), s2.bornAgain());
	    } catch(XQueryException e) {
		return null; 	// cannot happen
	    }
	}
    }
}
