/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;

/**
 *	Declared global variable in a module.
 */
public class GlobalVariable extends Expression
{
    public QName name;
    public Expression init;

    public GlobalVariable( QName name, Type type, Expression init ) {
	this.name = name;
	this.type = type;
	this.init = init;
    }

    public void dump( ExprDump d ) {
	d.header( this, "Global" );
        d.display("name", name);
        d.display("type", type);
        d.display("init", init);
    }

    public Expression child(int rank) {
	return (rank == 0)? init : null;
    }

    public int getFlags() {
	return init == null ? 0 : init.getFlags();
    }

} // end of class GlobalVariable

