/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.QName;
import java.util.NoSuchElementException;
import java.util.regex.*;

public class Pragma 
{
    public QName name;
    public String contents;
    static Pattern attrPattern =
           Pattern.compile("\\s*([\\w\\.-]+)\\s*=\\s*('[^']*'|\"[^\"]*\"|[^\\s]+)");

    public Pragma(QName name, String contents) {
        this.name = name;
        this.contents = contents;
    }

    public Iterator contentIterator() {
	return new Iterator();
    }

    /**
     *	Parses the contents as a list of pseudo-attributes of the form attr=value,
     *	iterates on attributes.
     */
    public class Iterator {
	Matcher matcher = attrPattern.matcher(contents);

	public boolean next() {
	    return matcher.find();
	}

	public String getAttrName() {
	    return matcher.group(1);
	}
	public String getAttrValue() {
	    String g = matcher.group(2);
	    return (g.charAt(0) == '\'' || g.charAt(0) == '"')?
		g.substring(1, g.length()-1) : g;
	}
    }
} // end of class Pragma

