/*
 * Decompiled with CFR 0.152.
 */
package installerui;

import installerui.MenuScroller;
import installerui.StatusBar;
import installerui.actions.AboutAction;
import installerui.actions.ExitAction;
import installerui.actions.LanguageAction;
import installerui.actions.LocaleAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import registry.LanguagePackItem;
import registry.Registry;
import utilities.PackageDBSync;
import utilities.PackageDatabase;
import utilities.ProgressStatusWorker;

public class MainWindow
extends JFrame {
    private Map<String, Action> actions;
    private String installationRootDir = "";
    private HashMap<String, String> installedPackages;
    private StatusBar statusBar;

    public MainWindow(String installRoot) {
        super("Bluestar LinguAssist");
        this.setInstallationRootDir(installRoot);
        URL imgURL = this.getClass().getResource("/resources/linguassist.png");
        if (imgURL != null) {
            ImageIcon appIcon = new ImageIcon(imgURL);
            this.setIconImage(appIcon.getImage());
        }
        this.actions = new HashMap<String, Action>();
        AbstractAction action = new ExitAction(this);
        action.setEnabled(true);
        this.actions.put("ExitAction", action);
        action = new LocaleAction(this);
        action.setEnabled(true);
        this.actions.put("LocaleAction", action);
        action = new AboutAction(this);
        action.setEnabled(true);
        this.actions.put("AboutAction", action);
        this.setDefaultCloseOperation(0);
        Terminator terminator = new Terminator();
        this.addWindowListener(terminator);
        this.addWindowStateListener(terminator);
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBorder(null);
        JMenu menu = new JMenu("File");
        JMenuItem menuItem = new JMenuItem(this.actions.get("ExitAction"));
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new JMenu("Language Packs");
        menuItem = new JMenuItem("junk");
        FontMetrics metrics = menuItem.getFontMetrics(menuItem.getFont());
        int maxWidth = 0;
        for (LanguagePackItem regItem : Registry.getLanguagePackRegistry()) {
            int width = metrics.stringWidth(regItem.getPackageLanguage());
            if (width > maxWidth) {
                maxWidth = width;
            }
            action = new LanguageAction(this, regItem);
            action.setEnabled(true);
            this.actions.put(regItem.getPackageLanguage(), action);
        }
        Dimension langDim = new Dimension(maxWidth + 15, menuItem.getPreferredSize().height);
        for (LanguagePackItem regItem : Registry.getLanguagePackRegistry()) {
            boolean containsDesktopLangPkg = false;
            String[] pkgRegions = regItem.getPackageRegions();
            for (int ix = 0; ix < pkgRegions.length && !containsDesktopLangPkg; ++ix) {
                String[] pkgItems = regItem.getPackageNames(pkgRegions[ix]);
                for (int i = 0; i < pkgItems.length && !containsDesktopLangPkg; ++i) {
                    if (!pkgItems[i].startsWith("kde")) continue;
                    containsDesktopLangPkg = true;
                }
            }
            menuItem = new JMenuItem(this.actions.get(regItem.getPackageLanguage()));
            if (containsDesktopLangPkg) {
                menuItem.setForeground(Color.black);
                menuItem.setFont(Font.decode(menuItem.getFont().getFamily() + "-bold"));
            } else {
                menuItem.setForeground(Color.gray);
            }
            menuItem.setPreferredSize(langDim);
            menu.add(menuItem);
        }
        MenuScroller.setScrollerFor(menu);
        menuBar.add(menu);
        menu = new JMenu("Help");
        menuItem = new JMenuItem(this.actions.get("LocaleAction"));
        menu.add(menuItem);
        menuItem = new JMenuItem(this.actions.get("AboutAction"));
        menu.add(menuItem);
        menuBar.add(menu);
        this.statusBar = new StatusBar();
        this.add("South", this.statusBar);
        this.setLocation(100, 100);
        this.setJMenuBar(menuBar);
        this.setSize(300, 75);
        this.setVisible(true);
        this.showIntroDialog();
        while (!this.checkInternetConnection()) {
            int option = JOptionPane.showConfirmDialog(null, "OK to try again. Cancel to exit.", "Networking Issue", 2);
            if (option != 2) continue;
            this.close();
        }
        this.syncPackageDatabases();
        this.getInstalledPackages();
    }

    private void syncPackageDatabases() {
        this.statusBar.setStatus("DbSync");
        ProgressStatusWorker dbsyncWorker = this.statusBar.getProgressStatusWorker();
        PackageDBSync packageDbSync = new PackageDBSync(this.getInstallationRootDir(), this.statusBar.getProgressStatusWorker());
        dbsyncWorker.runInBackground();
        packageDbSync.execCommands();
        dbsyncWorker.progressComplete();
        this.statusBar.setStatus("");
    }

    private void getInstalledPackages() {
        this.statusBar.setStatus("GetPDB");
        ProgressStatusWorker dbWorker = this.statusBar.getProgressStatusWorker();
        PackageDatabase packageDatabase = new PackageDatabase(this.getInstallationRootDir(), this.statusBar.getProgressStatusWorker());
        dbWorker.runInBackground();
        this.installedPackages = packageDatabase.getPackageDatabase();
        dbWorker.progressComplete();
        this.statusBar.setStatus("");
    }

    private boolean checkInternetConnection() {
        boolean bIsConnected = false;
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                bIsConnected = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bIsConnected) {
            JOptionPane.showMessageDialog(this, "Unable to establish network connection.", "Error", 0);
        }
        return bIsConnected;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public String getInstallationRootDir() {
        return this.installationRootDir;
    }

    public HashMap<String, String> getPackageDatabase() {
        return this.installedPackages;
    }

    private void setInstallationRootDir(String installRoot) {
        this.installationRootDir = installRoot;
    }

    private void showIntroDialog() {
        JOptionPane.showMessageDialog(this, "                    Welcome to LinguAssist!\n\n  Make sure you are connected to the internet.\n  You will be downloading packages from the\n  Arch Linux repositories.\n\n  If you are installing a Desktop Language,\n  please note that the Bold menu items listed\n  in the Language Packs menu contain the KDE\n  packages you will need to install.\n\n  Other menu items contain application-specific\n  language packs only.\n\n", "Intro", -1);
    }

    public void close() {
        this.dispose();
        System.exit(1);
    }

    public Action getActionByName(String name) {
        return this.actions.get(name);
    }

    private class Terminator
    extends WindowAdapter {
        private Terminator() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            MainWindow.this.close();
        }
    }
}

