/*
 * Decompiled with CFR 0.152.
 */
package installerui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import utilities.ProgressStatusWorker;

class StatusBar
extends JPanel {
    private JLabel statusLabel;
    private ProgressStatusWorker progressStatusWorker;

    public StatusBar() {
        this.setLayout(new BorderLayout(2, 2));
        this.statusLabel = new JLabel("Ready");
        this.statusLabel.setPreferredSize(new Dimension(60, 20));
        this.statusLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusLabel.setForeground(Color.black);
        this.add("West", this.statusLabel);
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setStringPainted(true);
        progressBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.progressStatusWorker = new ProgressStatusWorker(progressBar);
        this.add("Center", progressBar);
        this.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
    }

    public void setStatus(String status) {
        if (status.equals("")) {
            this.statusLabel.setText("Ready");
        } else {
            this.statusLabel.setText(status);
        }
        try {
            this.paint(this.getGraphics());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getStatus() {
        return this.statusLabel.getText();
    }

    public ProgressStatusWorker getProgressStatusWorker() {
        return this.progressStatusWorker;
    }
}

