/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.ArrayList;
import utilities.ExecRunner;
import utilities.ProgressBarOutputStream;
import utilities.ProgressStatusWorker;

public abstract class PackageTool {
    private ProgressStatusWorker commandProgress;
    private ExecRunner execRunner;
    private ArrayList<String> packageList;
    private String rootDirectory = "";

    public PackageTool(ArrayList<String> pkgList, String rootDir, ProgressStatusWorker progressStatus) {
        this.packageList = pkgList;
        this.rootDirectory = rootDir;
        this.commandProgress = progressStatus;
        this.commandProgress.runInBackground();
        this.execRunner = new ExecRunner(new ProgressBarOutputStream(this.commandProgress.getProgressBar()));
        this.execRunner.addExecCommand(this.createCommand());
    }

    protected ArrayList<String> getPackageList() {
        return this.packageList;
    }

    protected abstract String[] createCommand();

    protected String getRootDirectory() {
        return this.rootDirectory;
    }

    public void run() {
        this.execRunner.execCommands();
        this.commandProgress.progressComplete();
    }
}

