/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class ProgressStatusWorker {
    private JProgressBar progressBar;
    private StringBuffer stringBuffer = new StringBuffer();

    public ProgressStatusWorker(JProgressBar parentProgressBar) {
        this.progressBar = parentProgressBar;
        this.progressBar.setStringPainted(true);
    }

    public void runInBackground() {
        SwingWorker<Void, Integer> bgWorker = new SwingWorker<Void, Integer>(){

            @Override
            protected Void doInBackground() throws Exception {
                int multiplier = 1;
                while (!ProgressStatusWorker.this.progressBar.getString().equals("Done")) {
                    Thread.sleep(1000L);
                    ProgressStatusWorker.this.updateIndicator(2 * multiplier);
                    if (multiplier == 50) {
                        multiplier = 0;
                    }
                    ++multiplier;
                }
                return null;
            }
        };
        bgWorker.execute();
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void updateIndicator(int counter) {
        this.progressBar.setValue(counter);
        try {
            this.progressBar.paint(this.progressBar.getGraphics());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void progressComplete() {
        this.progressBar.setString("Done");
        try {
            Thread.sleep(1500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateIndicator(0);
    }

    public void setString(String progressNote) {
        this.progressBar.setString(progressNote);
        this.stringBuffer.append(progressNote);
    }

    public String getString() {
        return this.stringBuffer.toString();
    }
}

