/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import utilities.GlobalTypes;

public class MainWindow
extends JFrame {
    private final JTextArea textArea;
    private final JButton closeButton;
    private final JButton retryButton;
    private final JScrollPane scrollPane;
    private final MainWindow mainFrame = this;
    private GlobalTypes.ButtonPressed buttonPressed;
    private int execReturnValue = 0;

    public MainWindow(String windowTitle) {
        super("Stdout");
        if (windowTitle != null) {
            this.mainFrame.setTitle(windowTitle);
        } else {
            this.mainFrame.setTitle("Process Output");
        }
        this.setMinimumSize(new Dimension(400, 375));
        this.setLocation(50, 50);
        URL imgURL = this.getClass().getResource("/resources/bslx-icon.png");
        if (imgURL != null) {
            ImageIcon appIcon = new ImageIcon(imgURL);
            this.setIconImage(appIcon.getImage());
        }
        this.closeButton = new JButton("Close");
        this.closeButton.setEnabled(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.close();
            }
        });
        this.retryButton = new JButton("Retry");
        this.retryButton.setEnabled(false);
        this.retryButton.setVisible(false);
        this.retryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.retry();
            }
        });
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(2);
        this.scrollPane = new JScrollPane(this.getTextArea());
        this.setDefaultCloseOperation(0);
        Terminator terminator = new Terminator();
        this.addWindowListener(terminator);
        this.addWindowStateListener(terminator);
        while (!this.checkInternetConnection()) {
            int option = JOptionPane.showConfirmDialog(null, "OK to try again. Cancel to exit.", "Networking Issue", 2);
            if (option != 2) continue;
            System.exit(1);
        }
        this.setMainPanelLayout();
        this.setVisible(true);
    }

    public void setMainPanelLayout() {
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        listPane.add(Box.createRigidArea(new Dimension(0, 0)));
        listPane.add(this.getScrollPane());
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(this.getRetryButton());
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(this.getCloseButton());
        Container contentPane = this.getContentPane();
        contentPane.add((Component)listPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public JButton getRetryButton() {
        return this.retryButton;
    }

    private void setButtonPressed(GlobalTypes.ButtonPressed buttPressed) {
        this.buttonPressed = buttPressed;
    }

    public GlobalTypes.ButtonPressed getButtonPressed() {
        return this.buttonPressed;
    }

    private boolean checkInternetConnection() {
        boolean bIsConnected = false;
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                bIsConnected = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bIsConnected) {
            JOptionPane.showMessageDialog(this, "Unable to establish network connection.", "Error", 0);
        }
        return bIsConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.setButtonPressed(GlobalTypes.ButtonPressed.CloseButton);
        MainWindow mainWindow = this;
        synchronized (mainWindow) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retry() {
        this.setButtonPressed(GlobalTypes.ButtonPressed.RetryButton);
        MainWindow mainWindow = this;
        synchronized (mainWindow) {
            this.notify();
        }
    }

    private class Terminator
    extends WindowAdapter {
        private Terminator() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

