#ifndef DS_ADDIN_CONNECTION_H
#define DS_ADDIN_CONNECTION_H

/*
Sample Name: BlockCustomData

Sample Description:
    This sample demonstrate the usage of anonymous blocks in a drawing, 
    along with setting custom data and reading the data back.

Usage:
    This example has four commands, which can be invoked using either the
    command line or by using the menu "BlockCustomData".

    _BCDCREATENEWBLOCK "Create new block"
        Creates an anonymous block definition containing two circles:
            1 - Create and activate layer "two_circles_layer"
            2 - Create 2 circles on this layer
            3 - Make a *U block out of the circles
            
    _BCDINSERTBLOCK "Insert block"
        Inserts one or more instances of that block. The user will be
        prompted for specifying position, scale and rotation.

    _BCDSETCUSTOMDATA "Set custom data"
        Sets custom data of all selected entities. This sample provides
        input for these types: string, int16, int32, double, point. You can
        add as much data as you want before advancing to the next entity.

    _BCDREADCUSTOMDATA "Read custom data"
        Reads and displays the custom data of all selected entities at the
        command line.

Overview:
    Put in a few words, this add-in consists of the following parts:

    Functionality:
        The actual job is done by the four commands involved. This add-in
        has no graphical interface.

    Command classes:
        All four available commands derive from CommandBase. This base
        class provides an interface for both, registering a command to be
        used from the command line via CommandBase::registerCommand() as
        well as putting a command into a menu item via CommandBase::
        createUserCommand(), so done in BlockCustomDataApplication::
        CreateUserInterfaceAndCommands().

    Globally available options:
        This singleton Options class holds a globally accessible pointer
        to the dsApplication_c instance and to this add-in's ID.
        Furthermore, there is the miscellaneous.h, a collection of useful
        functions for converting between dsAPI and Qt classes. These
        functions are used throughout the add-in.

Notable dsAPI functions used:
    dsCommandMessage_c::PromptForBlockInsertion()
    dsCommandMessage_c::InsertBlock2()
    dsEntityHelper_c::GetCustomData()
    dsEntityHelper_c::SetCustomData()
    dsCustomData_c::InsertStringData()
    dsCustomData_c::InsertInteger16Data()
    dsCustomData_c::InsertInteger32Data()
    dsCustomData_c::InsertDoubleData()
    dsCustomData_c::InsertPointData()
*/

#include "dsApplication_c.h"
#include "dsInterfacePtr.h"

#include "BlockCustomData_global.h"

// You can append new commands like this:
// 1 - Append the header file here.
// 2 - Add the command as a private member of BlockCustomDataApplication.
// 3 - Go to bool BlockCustomDataApplication::CreateUserInterfaceAndCommands() and:
//     1 - Register your command using the registerCommand()
//         (then the command can be invoked from the command line).
//     2 - If it makes sense, add it to the user menu
//         (then the command can be invoked from the user menu as well).
#include "commands/CommandCreateNewBlock.h"
#include "commands/CommandInsertBlock.h"
#include "commands/CommandSetCustomData.h"
#include "commands/CommandReadCustomData.h"

class BlockCustomData_EXPORT BlockCustomDataApplication
{
public:
    BlockCustomDataApplication(dsApplication_c *dsApp) : application(dsApp){}

    dsApplication_c* getDsApp() { return application; } 
    bool CreateUserInterfaceAndCommands();
    static const dsString appID;

private:
    dsApplication_ptr application;

    // Commands
    CommandCreateNewBlock m_CommandCreateNewBlock;
    CommandInsertBlock m_CommandInsertBlock;
    CommandSetCustomData m_CommandSetCustomData;
    CommandReadCustomData m_CommandReadCustomData;
};

#endif // DS_ADDIN_CONNECTION_H
