#ifndef BLOCKLIBRARYMANAGER_H
#define BLOCKLIBRARYMANAGER_H

#include <QObject>
#include <QStringList>
#include <QCoreApplication>
#include "dsApplication_c.h"

// This class does the actual job of prompting the user and inserting all
// previously selected blocks.
class BlockLibraryManager
{
    Q_DECLARE_TR_FUNCTIONS(BlockLibraryManager)
public:
    BlockLibraryManager(
        dsApplication_c *application,
        const QStringList &drawings,
        const double &scale_x,
        const double &scale_y,
        const double &scale_z,
        const double &rotation,
        const bool &specify_scale,
        const bool &specify_rotation)
    : application(application)
    , m_drawings(drawings)
    , m_scale_x(scale_x)
    , m_scale_y(scale_y)
    , m_scale_z(scale_z)
    , m_rotation(rotation)
    , m_specify_scale(specify_scale)
    , m_specify_rotation(specify_rotation)
    {}

    bool insert();

protected:
    // Gives access to the application. You can retrieve access to the
    // command line, the current document, its model and its sketch
    // manager.
    dsApplication_c *application;

    // The list of all selected blocks due for insertion.
    QStringList m_drawings;

    // Default values for the blocks' scaling.
    double m_scale_x, m_scale_y, m_scale_z;

    // Default value for the blocks' rotation.
    double m_rotation;

    // Prompt the user to specify scale.
    bool m_specify_scale;

    // Prompt the user to specify rotation.
    bool m_specify_rotation;
};

#endif // BLOCKLIBRARYMANAGER_H
