#include <QDir>
#include <QDialog>
#include <QVBoxLayout>
#include <QDialogButtonBox>

#include "dsDocument_c.h"
#include "dsCommandMessage_c.h"
#include "dsInterfacePtr.h"

#include "../Options.h"
#include "../BlockLibraryManager.h"
#include "../ui/BlockLibraryWidget.h"
#include "CommandDialog.h"

bool CommandDialog::ExecuteNotify()
{
    // Leave, if the library does not exist
    if (!QDir(Options::instance().library_root_path).exists())
    {
        dsCommandMessage_ptr commandline;
        application->GetCommandMessage(&commandline);
        commandline->PrintLine(q2d(tr(
            "<p style=\"color:#990000;font-weight:bold\">"
            "Error: block library root directory missing.<br/>"
            "\"%1\" does not exist."
            "</p>")
            .arg(Options::instance().library_root_path)));
        return false;
    }

    // Construct a little dialog containing the BlockLibraryWidget,
    // an OK button, a Cancel button and a help button.
    QDialog dialog;
    BlockLibraryWidget w(&dialog);
    w.setLibraryRoot(Options::instance().library_root_path);
    QDialogButtonBox buttons(
        QDialogButtonBox::Ok | QDialogButtonBox::Cancel | QDialogButtonBox::Help,
        Qt::Horizontal,
        &dialog);
    QObject::connect(&buttons, SIGNAL(accepted()), &dialog, SLOT(accept()));
    QObject::connect(&buttons, SIGNAL(rejected()), &dialog, SLOT(reject()));
    QVBoxLayout *vbox = new QVBoxLayout;
    vbox->addWidget(&w);
    vbox->addWidget(&buttons);
    dialog.setLayout(vbox);
    dialog.resize(600, 400);

    // Leave, if the dialog was canceled.
    if (dialog.exec() != QDialog::Accepted)
        return false;

    // Insert all selected blocks.
    BlockLibraryManager manager(
        application,
        w.getSelectedDrawings(),
        w.scaleX(), w.scaleY(), w.scaleZ(),
        w.rotation(),
        w.specifyScaleLater(),
        w.specifyRotationLater());
    return manager.insert();
}
