#ifndef COMMANDDIALOG_H
#define COMMANDDIALOG_H

#include <QCoreApplication>
#include "../Options.h"
#include "../miscellaneous.h"
#include "../CommandBase.h"

class CommandDialog : public CommandBase
{
    Q_DECLARE_TR_FUNCTIONS(CommandDialog)
public:
    CommandDialog() : CommandBase(Options::instance().application) {}
    const dsString groupName() const { return Options::instance().ApiUuid; }
    const dsString globalName() const { return L"_BLMDIALOG"; }
    const dsString localName() const { return q2d(tr("BLMDIALOG")); }
    const dsString Description() const { return q2d(tr("Opens the dialog for the block library")); }
    const dsString ItemName() const { return q2d(tr("Open dialog")); }

    bool ExecuteNotify();
};

#endif // COMMANDDIALOG_H
